/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.springframework.util;

import java.text.MessageFormat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.context.ApplicationContext;

public class ApplicationContextTracker {
    private static final String FILTER = "(&(objectClass=org.springframework.context.ApplicationContext)(org.springframework.context.service.name={0}))";
    private ServiceTracker applicationContextServiceTracker;

    public ApplicationContextTracker(Bundle contributorBundle, BundleContext factoryBundleContext) {
        String filter = MessageFormat.format(FILTER, contributorBundle.getSymbolicName());
        try {
            this.applicationContextServiceTracker = new ServiceTracker(factoryBundleContext, FrameworkUtil.createFilter((String)filter), null);
            this.applicationContextServiceTracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.applicationContextServiceTracker != null) {
            this.applicationContextServiceTracker.close();
        }
    }

    public ApplicationContext getApplicationContext(int timeout) {
        ApplicationContext applicationContext = null;
        if (this.applicationContextServiceTracker != null) {
            try {
                applicationContext = (ApplicationContext)this.applicationContextServiceTracker.waitForService((long)timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return applicationContext;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

