/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.springframework.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.springframework.util.Activator;
import org.eclipse.springframework.util.ApplicationContextTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.springframework.context.ApplicationContext;

public class SpringExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private static final String TIMEOUT_PROPERTY_NAME = "org.eclipse.springextensionfactory.timeout";
    private Object bean;

    public Object create() throws CoreException {
        return this.bean;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String beanName = this.getBeanName(data, config);
        ApplicationContext appContext = this.getApplicationContext(config);
        if (appContext == null) {
            throw new RuntimeException("application context for bundle " + config.getContributor().getName() + " not found");
        }
        if (beanName == null) {
            throw new RuntimeException("bean id cound not be identified. Please check your extension declaration");
        }
        this.bean = appContext.getBean(beanName);
        if (this.bean instanceof IExecutableExtension) {
            ((IExecutableExtension)this.bean).setInitializationData(config, propertyName, data);
        }
    }

    private String getBeanName(Object data, IConfigurationElement config) {
        if (data != null && data.toString().length() > 0) {
            return data.toString();
        }
        if (config.getAttribute("id") != null) {
            return config.getAttribute("id");
        }
        if (config.getParent() != null && config.getParent() instanceof IExtension) {
            IExtension extensionDefinition = (IExtension)config.getParent();
            return extensionDefinition.getSimpleIdentifier();
        }
        return null;
    }

    private ApplicationContext getApplicationContext(IConfigurationElement config) {
        int timeout = 5000;
        try {
            String timeoutSetting = System.getProperty(TIMEOUT_PROPERTY_NAME);
            timeout = Integer.parseInt(timeoutSetting);
        }
        catch (Exception exception) {}
        String contributorName = config.getContributor().getName();
        Bundle contributorBundle = Platform.getBundle((String)contributorName);
        if (contributorBundle.getState() != 32) {
            try {
                contributorBundle.start();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        ApplicationContextTracker applicationContextTracker = new ApplicationContextTracker(contributorBundle, Activator.getDefault().getBundleContext());
        ApplicationContext applicationContext = null;
        try {
            applicationContext = applicationContextTracker.getApplicationContext(timeout);
        }
        finally {
            applicationContextTracker.close();
        }
        return applicationContext;
    }
}

